/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.engine.task.sTaskCheckEnvVariable;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCheckEnvVariable
extends PeerCompatibleTask {
    protected String m_envVarName = null;
    protected int m_maxLength = 0;
    protected boolean m_set = false;
    protected boolean m_restartService = false;
    private int m_maxDynamicVarLength = 0;
    private final String PATH_VAR_NAME = "PATH";
    private final String ORACLE_HOME = "ORACLE_HOME";

    @Override
    public boolean performTask() {
        boolean result = false;
        ResultSet evResultSet = new ResultSet();
        String errMsg = null;
        Vector<String> varNotSetNodes = new Vector<String>();
        Vector<String> lenExceedNodes = new Vector<String>();
        Vector<String> varSetNodes = new Vector<String>();
        Hashtable<String, Integer> maxVarLenOnNode = new Hashtable<String, Integer>(this.m_nodeList.length);
        if (this.m_envVarName == null || this.m_envVarName.length() == 0) {
            errMsg = s_msgBundle.getMessage("3921", true);
            this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errMsg));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        if (this.m_envVarName.contains("=")) {
            errMsg = s_msgBundle.getMessage("3920", true, (Object[])new String[]{this.m_envVarName});
            this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errMsg));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        ReportUtil.blankln();
        if (this.checkMaxLength()) {
            this.setDynamicLength();
            ReportUtil.sureprintln(s_msgBundle.getMessage("3905", false, (Object[])new String[]{this.m_envVarName}));
            ReportUtil.println(s_msgBundle.getMessage("3906", false, (Object[])new String[]{this.m_envVarName}));
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("3903", false, (Object[])new String[]{this.m_envVarName}));
            ReportUtil.println(s_msgBundle.getMessage("3904", false, (Object[])new String[]{this.m_envVarName}));
        }
        Trace.out((String)("TaskCheckEnvVariable :: Performing Environment Variable verification for variable : " + this.m_envVarName));
        sTaskCheckEnvVariable sTaskCheckEnv = new sTaskCheckEnvVariable(this);
        result = sTaskCheckEnv.checkEnvVariable(maxVarLenOnNode, varSetNodes, varNotSetNodes, lenExceedNodes, evResultSet);
        if (this.checkMaxLength()) {
            ReportUtil.writeColHeaders(ReportUtil.NODENAME, s_msgBundle.getMessage("3926", false), s_msgBundle.getMessage("3924", false), s_msgBundle.getMessage("3925", false), ReportUtil.COMMENT);
        } else {
            ReportUtil.writeColHeaders(ReportUtil.NODENAME, s_msgBundle.getMessage("3926", false), ReportUtil.COMMENT);
        }
        this.m_resultSet.uploadResultSet(evResultSet);
        Hashtable ht = this.m_resultSet.getResultTable();
        Enumeration e = ht.keys();
        Vector<String> verFailedNodes = new Vector<String>();
        Vector<String> opFailedNodes = new Vector<String>();
        boolean isSet = false;
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result evResult = (Result)ht.get(node);
            int varLengthNode = maxVarLenOnNode.size() > 0 ? maxVarLenOnNode.get(node) : 0;
            if (this.checkMaxLength() && evResult.getStatus() != 2) {
                this.m_resultSet.getResult(node).setHasResultValues(true);
                if (this.m_maxDynamicVarLength > 0) {
                    this.m_resultSet.getResult(node).setExpectedValue(Integer.toString(this.m_maxDynamicVarLength));
                } else {
                    this.m_resultSet.getResult(node).setExpectedValue(Integer.toString(this.m_maxLength));
                }
                this.m_resultSet.getResult(node).setActualValue(Integer.toString(varLengthNode));
                Trace.out((String)("TaskCheckEnvVariable:: Setting the expected length as " + Integer.toString(this.m_maxLength) + " and actual length as " + Integer.toString(varLengthNode)));
            } else if (!this.checkMaxLength() && evResult.getStatus() != 2) {
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(Boolean.toString(this.m_set));
                isSet = varSetNodes.size() > 0 ? varSetNodes.contains(node) : false;
                this.m_resultSet.getResult(node).setActualValue(Boolean.toString(isSet));
                Trace.out((String)("TaskCheckEnvVariable:: Setting the expected Status as " + Boolean.toString(this.m_set) + " and actual Status as " + Boolean.toString(isSet)));
            }
            if (evResult.getStatus() == 1) {
                Trace.out((String)("TaskCheckEnvVariable::Result.OPERATION_SUCCESSFUL Environment Variable check passed on Node " + node));
                if (!this.m_set) {
                    ReportUtil.writeRecord(node, ReportUtil.NO, ReportUtil.PASSED);
                    continue;
                }
                if (this.checkMaxLength()) {
                    ReportUtil.writeRecord(node, ReportUtil.YES, Integer.toString(this.m_maxLength), Integer.toString(varLengthNode), ReportUtil.PASSED);
                    continue;
                }
                ReportUtil.writeRecord(node, ReportUtil.YES, ReportUtil.PASSED);
                continue;
            }
            if (evResult.getStatus() == 3) {
                Trace.out((String)("TaskCheckEnvVariable::Result.VERIFICATION_FAILED:: Environment Variable check failed on Node " + node));
                if (this.m_set) {
                    if (varNotSetNodes.size() > 0 && varNotSetNodes.contains(node)) {
                        if (this.checkMaxLength()) {
                            ReportUtil.writeRecord(node, ReportUtil.NO, Integer.toString(this.m_maxLength), ReportUtil.UNKNOWN, ReportUtil.FAILED);
                        } else {
                            ReportUtil.writeRecord(node, ReportUtil.NO, ReportUtil.FAILED);
                        }
                        errMsg = s_msgBundle.getMessage("3916", true, (Object[])new String[]{this.m_envVarName, node});
                        this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                    } else if (this.checkMaxLength() && lenExceedNodes.size() > 0 && lenExceedNodes.contains(node)) {
                        ReportUtil.writeRecord(node, ReportUtil.YES, Integer.toString(this.m_maxLength), Integer.toString(varLengthNode), s_msgBundle.getMessage("3923", false, (Object[])new String[]{Integer.toString(varLengthNode), Integer.toString(this.m_maxLength)}));
                        errMsg = this.getLengthExceedErrMsg(this.m_envVarName, node, true);
                        this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                    }
                } else if (varSetNodes.size() > 0 && varSetNodes.contains(node)) {
                    if (this.checkMaxLength()) {
                        ReportUtil.writeRecord(node, ReportUtil.YES, ReportUtil.UNKNOWN, Integer.toString(varLengthNode), ReportUtil.FAILED);
                    } else {
                        ReportUtil.writeRecord(node, ReportUtil.YES, ReportUtil.FAILED);
                    }
                    errMsg = s_msgBundle.getMessage("3914", true, (Object[])new String[]{this.m_envVarName, node});
                    this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                }
                verFailedNodes.add(node);
                continue;
            }
            Trace.out((String)"Result.OPERATION FAILED:: cannot perform Environment Variable check");
            if (this.checkMaxLength()) {
                ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, ReportUtil.UNKNOWN, ReportUtil.UNKNOWN, ReportUtil.FAILED);
            } else {
                ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, ReportUtil.FAILED);
            }
            opFailedNodes.add(node);
        }
        if (result && this.m_resultSet.allSuccess()) {
            if (this.checkMaxLength()) {
                ReportUtil.printResult(s_msgBundle.getMessage("3907", false, (Object[])new String[]{this.m_envVarName}));
            } else {
                ReportUtil.printResult(s_msgBundle.getMessage("3909", false, (Object[])new String[]{this.m_envVarName}));
            }
            return true;
        }
        if (verFailedNodes.size() > 0) {
            if (this.m_set && lenExceedNodes.size() > 0 && this.m_maxLength > 0) {
                ReportUtil.printResult(s_msgBundle.getMessage("3908", false, (Object[])new String[]{this.m_envVarName}));
                errMsg = this.getLengthExceedErrMsg(this.m_envVarName, null, false);
                ReportUtil.printErrorWithNodes(errMsg, lenExceedNodes);
            }
            if (this.m_set && varNotSetNodes.size() > 0) {
                ReportUtil.printResult(s_msgBundle.getMessage("3910", false, (Object[])new String[]{this.m_envVarName}));
                errMsg = s_msgBundle.getMessage("3915", true, (Object[])new String[]{this.m_envVarName});
                ReportUtil.printErrorWithNodes(errMsg, varNotSetNodes);
            }
            if (!this.m_set && varSetNodes.size() > 0) {
                ReportUtil.printResult(s_msgBundle.getMessage("3910", false, (Object[])new String[]{this.m_envVarName}));
                errMsg = s_msgBundle.getMessage("3913", true, (Object[])new String[]{this.m_envVarName});
                ReportUtil.printErrorWithNodes(errMsg, varSetNodes);
            }
        }
        if (opFailedNodes.size() > 0) {
            ReportUtil.printResult(s_msgBundle.getMessage("3910", false, (Object[])new String[]{this.m_envVarName}));
            errMsg = s_msgBundle.getMessage("3917", true, (Object[])new String[]{this.m_envVarName});
            ReportUtil.printErrorWithNodes(errMsg, opFailedNodes);
        }
        return false;
    }

    private String getLengthExceedErrMsg(String variableName, String node, boolean forNode) {
        String msg = variableName.equalsIgnoreCase("PATH") && m_isAPImode ? (forNode ? s_msgBundle.getMessage("3929", true, (Object[])new String[]{Integer.toString(this.m_maxLength), Integer.toString(this.m_maxDynamicVarLength), node}) : s_msgBundle.getMessage("3928", true, (Object[])new String[]{Integer.toString(this.m_maxLength), Integer.toString(this.m_maxDynamicVarLength)})) : (forNode ? s_msgBundle.getMessage("3912", true, (Object[])new String[]{this.m_envVarName, Integer.toString(this.m_maxLength), node}) : s_msgBundle.getMessage("3911", true, (Object[])new String[]{this.m_envVarName, Integer.toString(this.m_maxLength)}));
        return msg;
    }

    @Override
    public String getDefaultDescription() {
        if (this.checkMaxLength()) {
            return s_msgBundle.getMessage("3927", false, (Object[])new String[]{this.m_envVarName});
        }
        if (this.m_set) {
            return s_msgBundle.getMessage("3901", false, (Object[])new String[]{this.m_envVarName});
        }
        return s_msgBundle.getMessage("3902", false, (Object[])new String[]{this.m_envVarName});
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("3900", false, (Object[])new String[]{this.m_envVarName});
    }

    @Override
    public String getElementDisplayName() {
        return s_msgBundle.getMessage("3922", false, (Object[])new String[]{this.m_envVarName});
    }

    @Override
    public ResultSet performPeer() throws VerificationException {
        ResultSet evResultSet = new ResultSet();
        Vector<String> varNotSetNodes = new Vector<String>();
        Vector<String> lenExceedNodes = new Vector<String>();
        Vector<String> varSetNodes = new Vector<String>();
        Hashtable<String, Integer> maxVarLenOnNode = new Hashtable<String, Integer>(this.m_nodeList.length);
        sTaskCheckEnvVariable sTaskCheckEnv = new sTaskCheckEnvVariable(this);
        sTaskCheckEnv.checkEnvVariable(maxVarLenOnNode, varSetNodes, varNotSetNodes, lenExceedNodes, evResultSet);
        Hashtable ht = evResultSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result evResult = (Result)ht.get(node);
            if (evResult.getStatus() == 1) {
                evResult.getResultInfoSet().add(0, ReportUtil.PASSED);
                continue;
            }
            if (evResult.getStatus() != 3) continue;
            evResult.getResultInfoSet().add(0, ReportUtil.FAILED);
            evResult.setStatus(1);
        }
        return evResultSet;
    }

    public void setVariableName(String name) {
        if (name != null && name.length() > 0) {
            this.m_envVarName = name;
        }
    }

    public void setMaxVariableLength(int length) {
        this.m_maxLength = length;
    }

    private boolean checkMaxLength() {
        return this.m_maxLength != 0;
    }

    private void setDynamicLength() {
        this.m_maxDynamicVarLength = this.m_maxLength;
        if (this.m_envVarName != null && this.m_envVarName.equalsIgnoreCase("PATH")) {
            String oracleHome = VerificationUtil.getVariableValue("ORACLE_HOME");
            if (oracleHome != null && oracleHome.trim().length() > 0) {
                String oracleHomeBin = oracleHome + "/bin;";
                this.m_maxDynamicVarLength = this.m_maxLength - oracleHomeBin.trim().length();
            }
        } else {
            this.m_maxDynamicVarLength = 0;
        }
    }

    public void checkVariableSet(boolean flag) {
        this.m_set = flag;
    }

    public void setRestartService(boolean restartSwitch) {
        this.m_restartService = restartSwitch;
    }
}

